clear
close all
clc

% IMPORTANT: the drain currents ID are referred to a batch of 16 devices!
% For correct normalization divide ID by 16
% Measurements file names:
% 'GTS/C2IVG.crv'   = 20 nm
% 'GTS/C11IVG.crv'  = 27 nm
% 'GTS/C4IVG.crv'   = 34 nm

fileName = 'GTS/C11IVG.crv';
fid = fopen(fileName, 'r');
a = textscan(fid,'%s','delimiter','\n');
fclose(fid);
C = string(a{1});
A = zeros(56,9);
j = 4;

figure(1)

for k = 1:2
    for i = 1:106
        B = sscanf(C(i+j), "%d %f %f %f %f %f %f %f %f");
        A(i,:) = B';
    end
    VD(:,k) = A(:,4);
    ID(:,k) = A(:,5);
    VG(:,k) = A(:,6);
    IG(:,k) = A(:,7);
    j = j + i + 1;

    grid on
    hold on
    box on
    xlabel('Gate-source voltage V_{GS}, V')
    ylabel('Drain current I_D, uA')
    xlim([-1.6, 0.5])
    xQuantity = 'GateOuterVoltage';
    yQuantity = 'DrainTotalCurrent';
    plot(VG(:,k),ID(:,k)*1e6/16,'--r','LineWidth',1.5)
    text(-1.55,-3.00,'VD = - 0.1 V')
    text(-1.55,-17.0,'VD = - 1.1 V')
end

figure(2)

for k = 1:2
    grid on
    hold on
    box on
    xlabel('Gate-source voltage V_{GS}, V')
    ylabel('Drain current I_D, A')
    xlim([-1.6, 0.5])
    ylim([-1e-4,-1e-16])
    set(gca,'YScale','log')
    set(gca,'YDir','reverse')
    xQuantity = 'GateOuterVoltage';
    yQuantity = 'DrainTotalCurrent';
    plot(VG(:,k),ID(:,k)/16,'--r','LineWidth',1.5)
    text(0.10,-3e-14,'VD = - 0.1 V')
    text(0.10,-3e-07,'VD = - 1.1 V')
end

% NORMALIZE ID FOR SUBTHRESHOLD ANALYSIS
ID = ID/16;

% Subthreshold analysis - Saturation regime
% USE 1e-8 FOR 20 AND 27 nm DEVICES
% USE 1e-7 FOR 34 nm DEVICE (it doesn't get to 1e-8 A)
SubThRegionEnd = 1e-8;      % [A]
indSubTh = find(abs(ID(:,2)) < SubThRegionEnd);
VG_SubTh = VG(indSubTh,2);
Vth_sat =  VG_SubTh(length(VG_SubTh));
fprintf("Saturation:\n");
fprintf("Vth = %.3f V\n\n", Vth_sat);

% Subthreshold analysis - Linear regime
indSubTh = find(abs(ID(:,1)) < SubThRegionEnd);
VG_SubTh = VG(indSubTh,1);
ID_SubTh = abs(ID(indSubTh,1));
Vth_lin =  VG_SubTh(length(VG_SubTh));
% Compute subthreshold slope
c = abs(polyfit(VG_SubTh,log10(ID_SubTh),1));
S_numerical = 1/c(1)*1000;   % mV/dec
fprintf("Linear:\n");
fprintf("Vth = %.3f V\n\n", Vth_lin);
fprintf("SS = %.3f mV/dec\n\n", S_numerical);

% DIBL = (Threshold Voltage DIBL - Threshold Voltage) / VDS
DIBL = abs(Vth_sat - Vth_lin);
fprintf("DIBL = %.3f \n", DIBL);
